<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Akun extends CI_Controller
{
  private $dataNilai;
  private $dataPrestasi;
  private $dataAfirmasi;

  public function __construct()
  {
    parent::__construct();
    is_logged_akun();
    $this->load->model('Akun_m', 'akun');
    $this->load->model('Ppdb_model', 'ppdb');
  }
public function index()
  {
    $data['title'] = 'Akun';
    $data['breadcumb'] = [
      [
        'link' => base_url('Akun'),
        'nama' => 'Home',
        'class' => ' active',
        'area' => ''
      ], [
        'link' => base_url('Akun/Wali'),
        'nama' => 'Wali',
        'class' => '',
        'area' => ''
      ]
    ];

    $data['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $data['title'] = 'Registrasi';
    $data['setting'] = $this->db->get('kop_surat')->row_array();
    $data['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $data['wali'] = $this->db->get_where('wali', ['idRegister' => $data['user']['id']])->row_array();
    $data['jalur'] = $this->akun->getJalur()->result_array();
    $data['dataUser'] = $this->GetBiodata();
    $data['provinsi'] = $this->db->get('provinces')->result_array();
    $data['pendidikan'] = $this->db->get('pendididikan')->result_array();
    $data['penghasilan'] = $this->db->get('penghasilan')->result_array();
    $data['pekerjaan'] = $this->db->get('pekerjaan')->result_array();
    $data['alamat'] = $this->akun->getAlamat();

    // data wali
    $data['wali'] = $this->db->get_where('wali', ['idRegister' => $data['user']['id']])->row_array();
    $data['pendidikan'] = $this->db->get('pendididikan')->result_array();
    $data['penghasilan'] = $this->db->get('penghasilan')->result_array();
    $data['pekerjaan'] = $this->db->get('pekerjaan')->result_array();
    $data['alamat'] = $this->akun->getAlamat();
    if ($data['user']['statusDaftar'] == 1) {
      // $this->load->view('themplate/Akun/maps', $data);
      $this->load->view('themplate/Akun/header', $data);
      $this->load->view('Akun/index', $data);
      $this->load->view('themplate/Akun/footer', $data);
      $this->load->view('themplate/Akun/footermaps', $data);
    } else {
      $this->load->view('themplate/Akun/header', $data);
      if ($data['user']['statusDaftar'] == 3) {
        $data['jarak'] = $this->akun->statistikJarakPerjalaur($data['user']['id_jalur']);
        $data['nilai'] = $this->akun->statistiknilaiPerjalaur($data['user']['id_jalur']);
        $data['usia'] = $this->akun->statistikUsiaPerjalaur($data['user']['id_jalur']);
        $data['skor'] = $this->akun->statistikKejuaraan();
        $data['statistik'] = $this->akun->statistikPendaftar();
        // var_dump($data['statistik']);
        // die;
        $data['pendaftar'] = $this->akun->pendaftaran();
            // var_dump($data['pendaftar']);die;
        $this->load->view('Akun/User_v', $data);
      } else {
        $data['userLogin'] = $this->akun->getDataUserPendaftar();
        $this->load->view('Akun/User', $data);
      }
      $this->load->view('themplate/Akun/footer', $data);
    }
  }


  public function Wali()
  {
    $data['breadcumb'] = [
      [
        'link' => base_url('Akun'),
        'nama' => 'Home',
        'class' => ' active',
        'area' => ''
      ], [
        'link' => base_url('Akun/Wali'),
        'nama' => 'Wali',
        'class' => '',
        'area' => ''
      ],
      [
        'link' => base_url('Akun/Nilai'),
        'nama' => 'Nilai',
        'class' => '',
        'area' => ''
      ]
    ];
    $data['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $this->form_validation->set_rules($this->_rolesWali());
    if ($this->form_validation->run() == false) {
      $data['title'] = 'Akun';
      $data['wali'] = $this->db->get_where('wali', ['idRegister' => $data['user']['id']])->row_array();
      $data['setting'] = $this->db->get('kop_surat')->row_array();
      $data['pendidikan'] = $this->db->get('pendididikan')->result_array();
      $data['penghasilan'] = $this->db->get('penghasilan')->result_array();
      $data['pekerjaan'] = $this->db->get('pekerjaan')->result_array();
      $data['alamat'] = $this->akun->getAlamat();
      $this->load->view('themplate/Akun/header', $data);
      if ($data['user']['statusDaftar'] == 1) {
        $this->load->view('Akun/form/Wali', $data);
      } else {
        if ($data['user']['statusDaftar'] == 3) {
          $data['jarak'] = $this->akun->statistikJarakPerjalaur($data['user']['id_jalur']);
          $data['nilai'] = $this->akun->statistiknilaiPerjalaur($data['user']['id_jalur']);
          $data['usia'] = $this->akun->statistikUsiaPerjalaur($data['user']['id_jalur']);
          $data['skor'] = $this->akun->statistikKejuaraan();
          $data['statistik'] = $this->akun->statistikPendaftar();

          $data['pendaftar'] = $this->akun->pendaftaran();
          $this->load->view('Akun/User_v', $data);
        } else {
          $data['pendaftarBelumVerifikasi'] = $this->akun->pendaftarBelumVerifikasi();
          $this->load->view('Akun/User', $data);
        }
      }
      $this->load->view('themplate/Akun/footer', $data);
    } else {
      $userdata['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
      $user = $userdata['user'];
      $data = [
        'idRegister' => htmlspecialchars($user['id']),
        'nisn' => htmlspecialchars($user['nisn']),
        'ayah	' => htmlspecialchars($this->input->post('ayah')),
        'ibu' => htmlspecialchars($this->input->post('ibu')),
        'nikAyah' => htmlspecialchars($this->input->post('nikAyah')),
        'nikIbu' => htmlspecialchars($this->input->post('nikIbu')),
        'TanggalLahirAyah' => htmlspecialchars($this->input->post('tanggalLahirAyah')),
        'TanggalLahirIbu' => htmlspecialchars($this->input->post('tanggalLahirIbu')),
        'pendidikanAyah' => htmlspecialchars($this->input->post('pendidikanAyah')),
        'pendidikanIbu' => htmlspecialchars($this->input->post('pendidikanIbu')),
        'pekerjaanAyah' => htmlspecialchars($this->input->post('pekerjaanAyah')),
        'pekerjaanIbu' => htmlspecialchars($this->input->post('pekerjaanIbu')),
        'penghasilanAyah' => htmlspecialchars($this->input->post('penghasilanAyah')),
        'penghasilanIbu' => htmlspecialchars($this->input->post('penghasilanIbu')),
        'notelepon' => htmlspecialchars($this->input->post('notelepon')),
        'status' => 1
      ];
      if ($this->akun->simpanWali($data) > 0) {
        echo json_encode(['pesan' => 'ok']);
      } else {
        echo json_encode(['pesan' => 'gagal']);
      }
    }
  }
  // end load halaman form step

  public function Nilai()
  {
    $data['breadcumb'] = [
      [
        'link' => base_url('Akun'),
        'nama' => 'Home',
        'class' => ' active',
        'area' => ''
      ], [
        'link' => base_url('Akun/Wali'),
        'nama' => 'Wali',
        'class' => '',
        'area' => ''
      ],
      [
        'link' => base_url('Akun/Nilai'),
        'nama' => 'Nilai',
        'class' => '',
        'area' => ''
      ],
      [
        'link' => base_url('Akun/Berkas'),
        'nama' => 'Berkas',
        'class' => '',
        'area' => ''
      ]
    ];
    $data['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $data['title'] = 'Nilai';
    $data['nilai'] = $this->db->get_where('nilai', ['id_pendaftar' => $data['user']['id']])->row_array();
    $data['setting'] = $this->db->get('kop_surat')->row_array();
    $data['alamat'] = $this->akun->getAlamat();
    $this->form_validation->set_rules($this->_rolesNilai());
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/Akun/header', $data);
      if ($data['user']['statusDaftar'] == 1) {
        $this->load->view('Akun/form/Nilai', $data);
      } else {
        if ($data['user']['statusDaftar'] == 3) {
          $data['jarak'] = $this->akun->statistikJarakPerjalaur($data['user']['id_jalur']);
          $data['nilai'] = $this->akun->statistiknilaiPerjalaur($data['user']['id_jalur']);
          $data['usia'] = $this->akun->statistikUsiaPerjalaur($data['user']['id_jalur']);
          $data['skor'] = $this->akun->statistikKejuaraan();
          $data['statistik'] = $this->akun->statistikPendaftar();
          $data['pendaftar'] = $this->akun->pendaftaran();
          $this->load->view('Akun/User_v', $data);
        } else {
          $data['pendaftarBelumVerifikasi'] = $this->akun->pendaftarBelumVerifikasi();
          $this->load->view('Akun/User', $data);
        }
      }
      $this->load->view('themplate/Akun/footer', $data);
    } else {
      $userdata['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
      $user = $userdata['user'];
      $form = $_POST;
      $jmlRataRatapai = round(($form['paiK4S1'] + $form['paiK4S2'] + $form['paiK5S1'] + $form['paiK5S2'] + $form['paiK6S1']) / 5, 2);
      $jmlRataRatapkn = round(($form['pknK4S1'] + $form['pknK4S2'] + $form['pknK5S1'] + $form['pknK5S2'] + $form['pknK6S1']) / 5, 2);
      $jmlRataRataIndo = round(($form['indoK4S1'] + $form['indoK4S2'] + $form['indoK5S1'] + $form['indoK5S2'] + $form['indoK6S1']) / 5, 2);
      $jmlRataRataMtk = round(($form['mtkK4S1'] + $form['mtkK4S2'] + $form['mtkK5S1'] + $form['mtkK5S2'] + $form['mtkK6S1']) / 5, 2);
      $jmlRataRataIpa = round(($form['ipaK4S1'] + $form['ipaK4S2'] + $form['ipaK5S1'] + $form['ipaK5S2'] + $form['ipaK6S1']) / 5, 2);
      $jmlRataRataips = round(($form['ipsK4S1'] + $form['ipsK4S2'] + $form['ipsK5S1'] + $form['ipsK5S2'] + $form['ipsK6S1']) / 5, 2);
      $jmlRataRatasbdp = round(($form['sbdpK4S1'] + $form['sbdpK4S2'] + $form['sbdpK5S1'] + $form['sbdpK5S2'] + $form['sbdpK6S1']) / 5, 2);
      $jmlRataRatapjok = round(($form['pjokK4S1'] + $form['pjokK4S2'] + $form['pjokK5S1'] + $form['pjokK5S2'] + $form['pjokK6S1']) / 5, 2);
      $jmlRataRatasunda = round(($form['sundaK4S1'] + $form['sundaK4S2'] + $form['sundaK5S1'] + $form['sundaK5S2'] + $form['sundaK6S1']) / 5, 2);
      $totalRataRataNilai = $jmlRataRatapai + $jmlRataRatapkn + $jmlRataRataIndo + $jmlRataRataIpa + $jmlRataRataMtk + $jmlRataRataips + $jmlRataRatasbdp + $jmlRataRatapjok + $jmlRataRatasunda;
      $data = [
        'id_pendaftar' => htmlspecialchars($user['id']),
        'koreg' => htmlspecialchars($user['koreg']), 
        'paiK4S1' => htmlspecialchars($this->input->post('paiK4S1')),
        'paiK4S2' => htmlspecialchars($this->input->post('paiK4S2')),
        'paiK5S1' => htmlspecialchars($this->input->post('paiK5S1')),
        'paiK5S2' => htmlspecialchars($this->input->post('paiK5S2')),
        'paiK6S1' => htmlspecialchars($this->input->post('paiK6S1')),
        
        'pknK4S1' => htmlspecialchars($this->input->post('pknK4S1')),
        'pknK4S2' => htmlspecialchars($this->input->post('pknK4S2')),
        'pknK5S1' => htmlspecialchars($this->input->post('pknK5S1')),
        'pknK5S2' => htmlspecialchars($this->input->post('pknK5S2')),
        'pknK6S1' => htmlspecialchars($this->input->post('pknK6S1')),

        'indoK4S1' => htmlspecialchars($this->input->post('indoK4S1')),
        'indoK4S2' => htmlspecialchars($this->input->post('indoK4S2')),
        'indoK5S1' => htmlspecialchars($this->input->post('indoK5S1')),
        'indoK5S2' => htmlspecialchars($this->input->post('indoK5S2')),
        'indoK6S1' => htmlspecialchars($this->input->post('indoK6S1')),

        'mtkK4S1' => htmlspecialchars($this->input->post('mtkK4S1')),
        'mtkK4S2' => htmlspecialchars($this->input->post('mtkK4S2')),
        'mtkK5S1' => htmlspecialchars($this->input->post('mtkK5S1')),
        'mtkK5S2' => htmlspecialchars($this->input->post('mtkK5S2')),
        'mtkK6S1' => htmlspecialchars($this->input->post('mtkK6S1')),

        'ipaK4S1' => htmlspecialchars($this->input->post('ipaK4S1')),
        'ipaK4S2' => htmlspecialchars($this->input->post('ipaK4S2')),
        'ipaK5S1' => htmlspecialchars($this->input->post('ipaK5S1')),
        'ipaK5S2' => htmlspecialchars($this->input->post('ipaK5S2')),
        'ipaK6S1' => htmlspecialchars($this->input->post('ipaK6S1')),

        'ipsK4S1' => htmlspecialchars($this->input->post('ipsK4S1')),
        'ipsK4S2' => htmlspecialchars($this->input->post('ipsK4S2')),
        'ipsK5S1' => htmlspecialchars($this->input->post('ipsK5S1')),
        'ipsK5S2' => htmlspecialchars($this->input->post('ipsK5S2')),
        'ipsK6S1' => htmlspecialchars($this->input->post('ipsK6S1')),

        'sbdpK4S1' => htmlspecialchars($this->input->post('sbdpK4S1')),
        'sbdpK4S2' => htmlspecialchars($this->input->post('sbdpK4S2')),
        'sbdpK5S1' => htmlspecialchars($this->input->post('sbdpK5S1')),
        'sbdpK5S2' => htmlspecialchars($this->input->post('sbdpK5S2')),
        'sbdpK6S1' => htmlspecialchars($this->input->post('sbdpK6S1')),

        'pjokK4S1' => htmlspecialchars($this->input->post('pjokK4S1')),
        'pjokK4S2' => htmlspecialchars($this->input->post('pjokK4S2')),
        'pjokK5S1' => htmlspecialchars($this->input->post('pjokK5S1')),
        'pjokK5S2' => htmlspecialchars($this->input->post('pjokK5S2')),
        'pjokK6S1' => htmlspecialchars($this->input->post('pjokK6S1')),

        'sundaK4S1' => htmlspecialchars($this->input->post('sundaK4S1')),
        'sundaK4S2' => htmlspecialchars($this->input->post('sundaK4S2')),
        'sundaK5S1' => htmlspecialchars($this->input->post('sundaK5S1')),
        'sundaK5S2' => htmlspecialchars($this->input->post('sundaK5S2')),
        'sundaK6S1' => htmlspecialchars($this->input->post('sundaK6S1')),
        'total' => $totalRataRataNilai
      ];

      if ($this->akun->simpanNilai($data) > 0) {
        echo json_encode(['pesan' => 'ok']);
      } else {
        echo json_encode(['pesan' => 'gagal']);
      }
    }
  }

  // Simpen data pendaftaran
  public function saveDaftar(){
    
    if (isset($_POST['jalurPpdb'])){
      $this->load->model('Register21', 'register');
      $message = [];
      $jalur = $this->ppdb->getDataJalur($_POST['jalurPpdb']);
      if($jalur['input_nilai']==1){
        // prepare data sesuai syarat khusus
        $dataNilai=MyFilter::fPostRaport($_POST);
        $this->dataNilai=$dataNilai;
      }
      if($jalur['inputPrestasi']==1){
        // iput prestasi di perlukan
           $dataPrestasi=MyFilter::fPostKejuaraan($_POST);
           $this->dataPrestasi=$dataPrestasi;
          
      }
       if($jalur['input_afirmasi']==1){
           // iput prestasi di perlukan
           $dataAfirmasi=MyFilter::fPostAfirmasi($_POST);
           $this->dataAfirmasi = $dataAfirmasi;
      }

      $result= $this->register->simpanDataPenftaran($this->dataAfirmasi,$this->dataPrestasi,$this->dataNilai,$jalur);
      if($result == true){

        $message=['pesan'=>'ok'];
        echo json_encode($message);
      }else{
         $message=['pesan'=>'error'];
        echo json_encode($message);
      }
       
    }else{
      // gagal Simpan
      $message=['pesan'=>'error'];
      echo json_encode($message);
       
    }
      
  }

  public function Berkas()
  {
    $data['breadcumb'] = [
      [
        'link' => base_url('Akun'),
        'nama' => "Home",
        'class' => "",
        'area' => ''
      ],
      [
        'link' => "",
        'nama' => "Berkas",
        'class' => 'active',
        'area' => ' aria-current="page"'
      ],

    ];
    $data['user'] = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $data['title'] = 'Registrasi';
    $data['setting'] = $this->db->get('kop_surat')->row_array();
    if ($data['setting']['wilayah'] == $data['user']['kota']) {
      $data['jalur'] = $this->akun->getJalur()->result_array();
    } else {
      $data['jalur'] = $this->akun->getJalurWil()->result_array();
    }
       $data['alamat'] = $this->akun->getAlamat();
      $this->load->view('themplate/Akun/header', $data);
      if ($data['user']['statusDaftar'] == 1) {
        $this->load->view('Akun/form/Berkas', $data);
      } else {
        if ($data['user']['statusDaftar'] == 3) {
          $data['jarak'] = $this->akun->statistikJarakPerjalaur($data['user']['id_jalur']);
          $data['nilai'] = $this->akun->statistiknilaiPerjalaur($data['user']['id_jalur']);
          $data['usia'] = $this->akun->statistikUsiaPerjalaur($data['user']['id_jalur']);
          $data['skor'] = $this->akun->statistikKejuaraan();
          $data['statistik'] = $this->akun->statistikPendaftar();
          $data['pendaftar'] = $this->akun->pendaftaran();
          $this->load->view('Akun/User_v', $data);
        } else {
          $data['pendaftarBelumVerifikasi'] = $this->akun->pendaftarBelumVerifikasi();
          $this->load->view('Akun/User', $data);
        }
      }
      $this->load->view('themplate/Akun/footer', $data);
      
        
  }
  
  // end load halaman form step



  public function Biodata()
  {
    $longitude = $this->input->post('longitude');
    $sekolah = $this->db->get_where('kop_surat', ['id' => 1])->row_array();
    $longSekolah = $sekolah['longitude'];
    $jarak = $this->akun->jarak($longSekolah, $longitude) * 1000;
    $jarak = round($jarak, 2);
    $data = [
      'tempatLahir' => htmlspecialchars($this->input->post('tempatLahir')),
      'tglLahir' => htmlspecialchars($this->input->post('tglLahir')),
      'kk' => htmlspecialchars($this->input->post('kk')),
      'jk' => htmlspecialchars($this->input->post('jk')),
      'noHp' => htmlspecialchars($this->input->post('noHp')),
      'tinggiBadan' => htmlspecialchars($this->input->post('tinggiBadan')),
      'beratBadan' => htmlspecialchars($this->input->post('beratBadan')),
      'sekolahAsal' => htmlspecialchars($this->input->post('sekolahAsal')),
      'npsn' => htmlspecialchars($this->input->post('npsn')),
      'provinsi' => htmlspecialchars($this->input->post('provinsi')),
      'kota' => htmlspecialchars($this->input->post('kota')),
      'kecamatan' => htmlspecialchars($this->input->post('kecamatan')),
      'desa' => htmlspecialchars($this->input->post('desa')),
      'rt' => htmlspecialchars($this->input->post('rt')),
      'rw' => htmlspecialchars($this->input->post('rw')),
      'longitude' => $longitude,
      'kodePos' => htmlspecialchars($this->input->post('kodePos')),
      'alamat' => htmlspecialchars(trim($this->input->post('alamat'))),
      'agama' => htmlspecialchars(trim($this->input->post('agama'))),
      'anak_ke' => htmlspecialchars(trim($this->input->post('anak_ke'))),
      'jarak' => $jarak,
      'usia' => $this->akun->hitungUsia($this->input->post('tglLahir')),
      'statusDaftar' => 1
    ];

    if ($this->akun->prosesBiodata($data) > 0) {
      echo json_encode(['pesan' => 'ok']);
    } else {
      echo json_encode(['pesan' => 'gagal']);
    }
  }
  // ambil data user login lewat ajax
  public function GetBiodata()
  {
    return $this->akun->biodata();
  }

  // ambil data provinsi lewat ajax
  public function provinsi()
  {
    echo json_encode($this->akun->getProvinsi()->result_array());
  }

  // private function
  private function _rolesWali()
  {
    $dataRules = array(
      array(
        'field' => 'ayah',
        'label' => 'ayah',
        'rules' => 'required|trim',
        'errors' => array(
          'required' => 'ayah Harus Di isi',
        )

      ), array(
        'field' => 'tanggalLahirAyah',
        'label' => 'tanggalLahirAyah',
        'rules' => 'required',
        'errors' => array(
          'required' => 'tanggal Lahir Ayah tidak boleh kosong',


        )
      ),

      array(
        'field' => 'pekerjaanAyah',
        'label' => 'pekerjaan Ayah',
        'rules' => 'required',
        'errors' => array(
          'required' => 'Pekerjaan Ayah tidak boleh kosong',


        )
      ),
      array(
        'field' => 'penghasilanAyah',
        'label' => 'penghasilan Ayah',
        'rules' => 'required',
        'errors' => array(
          'required' => 'penghasilan Ayah tidak boleh kosong',


        )
      ),
      array(
        'field' => 'ibu',
        'label' => 'Ibu',
        'rules' => 'required',
        'errors' => array(
          'required' => 'ibu tidak boleh kosong',
        )
      ),
      array(
        'field' => 'nikIbu',
        'label' => 'nik Ibu',
        'rules' => 'required',
        'errors' => array(
          'required' => 'nik Ibu tidak boleh kosong',
        )
      ),
      array(
        'field' => 'tanggalLahirIbu',
        'label' => 'tanggal LahirIbu',
        'rules' => 'required',
        'errors' => array(
          'required' => 'tanggal LahirIbu tidak boleh kosong',
        )
      ),
      array(
        'field' => 'pendidikanIbu',
        'label' => 'pendidikan Ibu',
        'rules' => 'required',
        'errors' => array(
          'required' => 'pendidikan Ibu tidak boleh kosong',
        )
      ),
      array(
        'field' => 'pekerjaanIbu',
        'label' => 'pekerjaan Ibu',
        'rules' => 'required',
        'errors' => array(
          'required' => 'pekerjaan Ibu tidak boleh kosong',
        )
      ),
      array(
        'field' => 'penghasilanIbu',
        'label' => 'penghasilan Ibu',
        'rules' => 'required',
        'errors' => array(
          'required' => 'penghasilan Ibu tidak boleh kosong',
        )
      ),
      array(
        'field' => 'notelepon',
        'label' => 'notelepon',
        'rules' => 'required',
        'errors' => array(
          'required' => 'no telepon Ibu tidak boleh kosong',
        )
      ),

    );
    return $dataRules;
  }
  // private function
  private function _rolesNilai()
  {
    $dataRules = array(
      array(
        'field' => 'paiK4S1',
        'label' => 'paiK4S1',
        'rules' => 'required|trim',
        'errors' => array(
          'required' => 'Harus Di isi'
        )
      )
    );
    return $dataRules;
  }
  private function _rolesBerkas()
  {
    $dataRules = array(
      array(
        'field' => 'jalurPpdb',
        'label' => 'jalurPpdb',
        'rules' => 'required|trim',
        'errors' => array(
          'required' => 'Harus Di pilih'
        )
      )
    );
    return $dataRules;
  }

  // get data penyelengara
  public function penyelengara()
  {
    echo json_encode($this->akun->dataPeyelengara()->result_array());
  }

  // memilih kategori kejuaraan berdasarkan penyelengagara
  public function KategoriKejuaraan()
  {
    echo json_encode($this->akun->KategoriKejuaraan($_POST['id'])->result_array());
  }

  public function tingkatPrestasi()
  {
    echo json_encode($this->akun->tingkatKejuaraan($_POST['id'])->result_array());
  }

  // get data jenis afirmasi
  public function jenisAfirmasi()
  {
    echo json_encode($this->akun->jenisAfirmasi()->result_array());
  }

  // get data afirmasi by id
  public function getAfirmasiById()
  {
    echo json_encode($this->akun->getAfirmasiById($_POST['id'])->row_array());
  }

  public function CekNisn(){
    if(isset($_POST['nisn'])){
       echo $this->akun->cekNisnBiforeReg($_POST['nisn']);
    }
  }

  public function CekEmail(){
    if(isset($_POST['nisn'])){
       echo $this->akun->cekEmailBiforeReg($_POST['nisn']);
    }
  }
  public function cekNIK(){
    if(isset($_POST['nik'])){
      echo $this->akun->cekNikBiforeReg($_POST['nik']);
   }
 }


  //   cetak bukti pendaftaran
  public function PrintRegistrasi()
  {
    $this->load->model('Pendaftar_m', 'item_m');
    $user = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $data= $this->item_m->getdataprintByjalur($user['koreg']);
    $mpdf = new \Mpdf\Mpdf(['debug' => false,
        'format' => 'Legal-P',
        'margin_left' => 22,
        'margin_right' => 20,
        'margin_top' => 15,
        'margin_bottom' => 0,
        'margin_header' => 0,
        'margin_footer' => 0,
    ]);
    $html = '';
 
    $html = $this->load->view('Home2/Cetak', $data, true);
    $html2 = $this->load->view('Home2/perjanjianMutlakOrangtua', $data, true);
    $mpdf->WriteHTML($html);
    $mpdf->AddPage();
    $mpdf->WriteHTML($html2);
    $mpdf->SetHTMLFooter('
<table width="100%">
    <tr>
        <td width="33%" style="font-size:8px;">{DATE j-m-Y}</td>
        <td width="33%" align="center" style="font-size:8px;">{PAGENO}/{nbpg}</td>
        <td width="33%" style="text-align: right; font-size:8px;">' . $data['dataSekolah']['nama_sekolah']  . '</td>
    </tr>
</table>');
    $mpdf->Output($user['koreg'] . '-' . $data['user']['nama'] . '-' . $data['user']['sekolahAsal'] . '-' . $data['user']['nisn'] . '.pdf', 'I');
  }


  // Get data longitudeBy user
  public function getLongitudeByUser()
  {

    $data = $this->db->get_where('register', ['email' => $this->session->userdata('pin')])->row_array();
    $result = [
      "longitude" => $data['longitude']
    ];

    echo json_encode($result);
    // echo json_encode($this->akun->prosesGetDataLongByUser());
  }


  // pemilihan jalur ppdb dihalaman pendaftar
  public function changejalur(){

   echo json_encode($this->ppdb->getDataJalur($_POST['id']));

  }




}
