<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Ppdb extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();

    is_logged_in();

    $this->load->model('ppdb_model', 'ppdb');
  }

  public function index()
  {
    $data['title'] = 'Persyaratan';
    $data['menu'] = $this->db->get('user_menu')->result_array();
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $data['sarat'] = $this->ppdb->getDataSyarat();
    $data['jalur'] = $this->ppdb->getDataPpdb();
    $this->form_validation->set_rules('syarat', 'syarat', 'required', array('required' => 'Form Persyaratan tidak boleh Kosong'));
    $this->form_validation->set_rules('jalur', 'jalur', 'required', array('required' => 'Peruntukan Jalur Belum Di pilih'));

    if ($this->form_validation->run() == false) {
      // var_dump($data['sarat']);
      // die;
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('ppdb/index', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {
      if ($this->ppdb->simpanSyarat($_POST) > 0) {
        $this->session->set_flashdata('message', '
          <div class="alert alert-success" role="alert">
        Data Persyaratan berhasil ditambah!!
          </div>');
        redirect('ppdb');
      }
    }
  }



  public function nonAkademik()
  {
    $data['title'] = 'Nilai Nonakademik';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $data['tingkat'] = $this->ppdb->getDataKategoriNilaiAkademik();
    $data['penyelengara'] = $this->db->get('kategori_penyelengara')->result_array();
    $this->form_validation->set_rules('tingkat', 'tingkat', 'required', array('required' => 'Tingkat Prestasi Tidak  boleh Kosong'));
    $this->form_validation->set_rules('nilaiPrestasi', 'nilaiPrestasi', 'required', array('required' => 'Score Prestasi  tidak boleh Kosong'));
    $this->form_validation->set_rules('penyelengara', 'Penyelengara', 'required', array('required' => 'Penyelengara Belum Dipilih'));
    $this->form_validation->set_rules('kategori', 'Kategori', 'required', array('required' => 'Kategori Kejuaraan Belum Dipilih'));
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('ppdb/Nonakademik', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {
      if ($this->ppdb->prosesSimpanPrestasi($_POST) > 0) {
        $this->session->set_flashdata('message', '
          <div class="alert alert-success" role="alert">
        Data Prestasi berhasil ditambah!!
          </div>');
        redirect('ppdb/Nonakademik');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
      Data Prestasi Gagal ditambah!!
        </div>');
        redirect('ppdb/Nonakademik');
      }
    }
  }

  
  public function rangking()
  {
    $data['title'] = 'Skor Perangkingan';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    
    
    $this->form_validation->set_rules($this->_rulesFormRangking());
    $data['rangking'] = $this->ppdb->getSkorrangking();
    $data['dataAfirmasiTabel'] = $this->ppdb->getDataTabelJenisAfirmasi();
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('ppdb/skorRangking', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {
      if ($this->ppdb->prosesSimpanRangking($_POST) > 0) {
        $this->session->set_flashdata('message', '
          <div class="alert alert-success" role="alert">
        Data Rangking berhasil ditambah!!
          </div>');
        redirect('ppdb/rangking');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
      Data Rangking Gagal ditambah!!
        </div>');
        redirect('ppdb/rangking');
      }
    }
  }

  public function tambahAfirmasi(){
   
    // cek ke tabel afirmasi
    if($this->ppdb->simpanDataAfirmasi($_POST)>0){
      $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
          Data Afirmasi Berhasil di tambah!!
        </div>');
        redirect('ppdb/rangking');
    }else{
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
        Data Afirmasi Gagal di tambah!!
      </div>');
      redirect('ppdb/rangking');
    }
 
   
  }

  public function getDataAfirmasiUntukTableAfirmasi(){
    echo json_encode($this->db->get_where('jenis_afirmasi', ['id' => $_POST['id']])->row_array());
  }

  public function editProsesDataAfirmasi(){
    if($this->ppdb->editDataTableAfirmasi($_POST)>0){
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
          Data Afrimasi berhasil di ubah!!
      </div>');
    redirect('ppdb/rangking');
    }else{
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
          Data Afrimasi gagal di ubah!!
      </div>');
    redirect('ppdb/rangking');

    }
  }

  public function hapusAfirmasi($id){
    $cekTabelAfirmasi = $this->db->get_where('afirmasi', ['afirmasi' => $id])->num_rows();
    if($cekTabelAfirmasi >0){
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
          Gagal Hapus! afirmasi sudah di gunakan oleh pendaftar
      </div>');
    redirect('ppdb/rangking');
    }else{
      if($this->ppdb->hapusAfirmasi($id)>0){
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
            Gagal Hapus! 
        </div>');
    redirect('ppdb/rangking');

      }else{
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
            Data afirmasi berhasil di hapus
        </div>');
    redirect('ppdb/rangking');

        
      }
    }
  }

public function editProsesRangking(){
    if ($this->ppdb->prosesSimpanEditRangking($_POST) > 0) {
        $this->session->set_flashdata('message', '
          <div class="alert alert-success" role="alert">
        Data Skor berhasil di ubah!!
          </div>');
        redirect('ppdb/rangking');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
      Data Skor Rangking Gagal di ubah!!
        </div>');
        redirect('ppdb/rangking');
      }
}

public function hapusRangking($id){
    $cekTabelNilai = $this->db->get_where('nilai', ['isRank' => $id])->num_rows();
    if($cekTabelNilai>0){
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
          Gagal Hapus! Data rangking sudah di gunakan oleh pendaftar
      </div>');
    redirect('ppdb/rangking');

    } else {

      if ($this->ppdb->prosesHapusRangking($id) > 0) {
        $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
    Data Skor Rangking berhasil Hapus!!
      </div>');
        redirect('ppdb/rangking');
      } else {
        $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
    Data Skor Rangking Gagal Hapus!!
      </div>');
        redirect('ppdb/rangking');
      }
    }

}

  public function getDataKategoriByIdPeyelengara()
  {
    echo json_encode($this->db->get_where('kat_satuan', ['id_penyelengara' => $_POST['id']])->result_array());
  }


  public function getDataPrestasi()
  {
    echo json_encode($this->db->get_where('prestasi', ['id' => $_POST['id']])->row_array());
  }

  public function getDataRangking(){
    echo json_encode($this->db->get_where('rangking_skor', ['id_rangking' => $_POST['id']])->row_array());
  }

  public function getDataKatSatuan()
  {
    echo json_encode($this->db->get_where('kat_satuan', ['id_satuan' => $_POST['id']])->row_array());
  }

  public function editNilaiPrestasi()
  {
    
    $data['title'] = 'Nilai Nonakademik';
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $data['tingkat'] = $this->ppdb->getDataKategoriNilaiAkademik();
    $data['penyelengara'] = $this->db->get('kategori_penyelengara')->result_array();
    $this->form_validation->set_rules('tingkat', 'tingkat', 'required', array('required' => 'Tingkat Prestasi Tidak  boleh Kosong'));
    $this->form_validation->set_rules('nilaiPrestasi', 'nilaiPrestasi', 'required', array('required' => 'Score Prestasi  tidak boleh Kosong'));
    $this->form_validation->set_rules('penyelengara', 'Penyelengara', 'required', array('required' => 'Penyelengara Belum Dipilih'));
    $this->form_validation->set_rules('kategori', 'Kategori', 'required', array('required' => 'Kategori Kejuaraan Belum Dipilih'));
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('ppdb/Nonakademik', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {

      if ($this->ppdb->prosesEditNilaiPrestasi($_POST) > 0) {
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
      Data Prestasi berhasil Diedit!!
        </div>');
        redirect('ppdb/Nonakademik');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
      Data Tersimpan!
        </div>');
        redirect('ppdb/Nonakademik');
      }
    }
  }

  public function hapusPrestasi($id)
  {
    // xek dulu ke table ke juaraan siswa susdah ada menggunakan atau belum
    $kejuaraansiswa = $this->db->get_where('kejuaraansiswa', ['id_kejuaraan' => $id])->num_rows();
    if($kejuaraansiswa > 0){

      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
        Mohon maaf data skor prestasi ini tidak bisa di hapus, sudah ada pendaftar yang menggunakan
      </div>');
      redirect('ppdb/Nonakademik');
    }else{
      if ($this->ppdb->prosesHapusPrestasi($id) > 0) {
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
      Data Prestasi berhasil Hapus!!
        </div>');
        redirect('ppdb/Nonakademik');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
      Data Prestasi Gagal Hapus!!
        </div>');
        redirect('ppdb/Nonakademik');
      }
    }
   
  }
  // batas akhir data nili prestasi
  public function edit()
  {

    echo json_encode($this->ppdb->getDataSyaratById($_POST['id']));
  }

  public function editProses()
  {
    if ($this->ppdb->prosesEdit($_POST) > 0) {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Persyaratan berhasil diedit!!
      </div>');
      redirect('ppdb');
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Persyaratan Gagal  edit!!
      </div>');
      redirect('ppdb');
    }
  }

  public function hapusSyarat($id)
  {
    $this->db->delete('persyaratan', ['id' => $id]);
    $this->session->set_flashdata('message', '
    <div class="alert alert-success" role="alert">
   Data Persyaratan Berhasil dihapus!!
    </div>');
    redirect('ppdb');
  }


  // jalus ppdb

  public function jalurPpdb()
  {
    $data['title'] = 'Jalur PPDB';
    $data['menu'] = $this->db->get('user_menu')->result_array();
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    // $data['sarat'] = $this->ppdb->getDataSyarat();
    $data['jalur'] = $this->ppdb->getDataPpdb();
    $this->form_validation->set_rules('jalur', 'Jalur', 'required', array('required' => 'Form Jalur PPDB tidak boleh Kosong'));
    $this->form_validation->set_rules('quota', 'Quota', 'required|numeric', array('required' => 'Form Jalur Quota tidak boleh Kosong', 'numeric' => 'Quota Hanya Angka!!'));
    if ($this->form_validation->run() == false) {
      // var_dump($data['sarat']);
      // die;
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('ppdb/jalurPPDB', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {
      if ($this->ppdb->simpanJalurPPDB($_POST) > 0) {
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
       Data Jalur PPDB berhasil ditambah!!
        </div>');
        redirect('ppdb/jalurPPDB');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
        Jalur PPDB  Gagal ditambah!!
        </div>');
        redirect('ppdb/jalurPPDB');
      }
    }
  }

  public function getJalurByid()
  {
    echo json_encode($this->ppdb->getJalurId($_POST['id']));
  }

  public function getDataInformasi()
  {
    echo json_encode($this->ppdb->ambilDataInformasi($_POST['id']));
  }

  public function editJalurPpdb()
  {
    $cekPendaftar = $this->db->get_where('register', ['id_jalur' => $_POST['idJalur']])->num_rows();
    if($cekPendaftar >0){
      if ($this->ppdb->editQuotaOnly($_POST) > 0){
        $this->session->set_flashdata('message', '
        <div class="alert alert-warning" role="alert">
           <p>Sudah ada pendaftar di jalur ini, Perubahan hanya akan berpengaruh pada Quota nama jalur Pendaftaran</p>
           <p>untuk menonaktifkan/mengaktifkan inputan nilai, afirmasi dan prestasi sudah tidak bia di lakukan lagi</p>
        </div>');
        redirect('ppdb/jalurPpdb');
      }else{
        $this->session->set_flashdata('message', '
        <div class="alert alert-warning" role="alert">
           <p>Sudah ada pendaftar di jalur ini, Perubahan hanya akan berpengaruh pada Quota nama jalur Pendaftaran</p>
           <p>untuk menonaktifkan/mengaktifkan inputan nilai, afirmasi dan prestasi sudah tidak bia di lakukan lagi</p>
        </div>');
        redirect('ppdb/jalurPpdb');
      }

    } else {
      if ($this->ppdb->prosesEditJalur($_POST) > 0) {
        $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Jalur PPDB berhasil diedit!!
      </div>');
        redirect('ppdb/jalurPpdb');
      } else {
        $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
     Data Jalur PPDB gagal diedit!!
      </div>');
        redirect('ppdb/jalurPpdb');
      }
    }
  }

  public function hapusJalurPpdb($id)
  {
    if ($this->ppdb->prosesHapusJalur($id) > 0) {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Jalur PPDB berhasil Hapus!!!
      </div>');
      redirect('ppdb/jalurPpdb');
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
     Data Jalur PPDB gagal Hapus!!!
      </div>');
      redirect('ppdb/jalurPpdb');
    }
  }
  // informasi method
  public function informasi()
  {
    $data['title'] = 'Informasi';
    $data['menu'] = $this->db->get('user_menu')->result_array();
    $data['informasi'] = $this->db->get('informasi')->result_array();
    // var_dump($data['informasi']);die;
    $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
    $this->form_validation->set_rules('titleInformasi', 'Informasi', 'required', array('required' => 'Form Informasi tidak boleh Kosong'));
    if ($this->form_validation->run() == false) {
      // var_dump($data['sarat']);
      // die;
      $this->load->view('themplate/admin/header', $data);
      $this->load->view('themplate/admin/sidebar', $data);
      $this->load->view('themplate/admin/topbar', $data);
      $this->load->view('ppdb/informasi', $data);
      $this->load->view('themplate/admin/footer', $data);
    } else {
      if ($this->ppdb->simpanInformasi($_POST) > 0) {
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
       Data Informasi berhasil ditambah!!
        </div>');
        redirect('ppdb/informasi');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-danger" role="alert">
       Informasi  Gagal ditambah!!
        </div>');
        redirect('ppdb/informasi');
      }
    }
  }

  public function getInformasiByid()
  {
    echo json_encode($this->ppdb->getDataInformasiByid($_POST['id']));
  }

  public function editInformasi()
  {
    if ($this->ppdb->prosesEditInformasi($_POST) > 0) {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Informasi berhasil diedit!!
      </div>');
      redirect('ppdb/informasi');
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Tersimpan !
      </div>');
      redirect('ppdb/informasi');
    }
  }

  public function hapusInformasi($id)
  {
    if ($this->ppdb->prosesHapusInformasi($id) > 0) {
      $this->session->set_flashdata('message', '
      <div class="alert alert-success" role="alert">
     Data Informasi berhasil diedit!!
      </div>');
      redirect('ppdb/informasi');
    } else {
      $this->session->set_flashdata('message', '
      <div class="alert alert-danger" role="alert">
     Data Informasi gagal di edit!!
      </div>');
      redirect('ppdb/informasi');
    }
  }

  public function _rulesFormRangking(){
    $config = array(
        array(
                'field' => 'namaRangking',
                'label' => 'namaRangking',
                'rules' => 'required',
                 'errors' => array(
                        'required' => 'nama rangking harus di isi',
                ),
        ),
        array(
                'field' => 'skorRangking',
                'label' => 'skorRangking',
                'rules' => array(
                  'required','integer'),
                'errors' => array(
                        'required' => 'skor rangking harus di isi',
                        'integer'=>'Skor harus number'
                ),
        ),
      );

    return $config;
  }
}
