<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Register extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    $this->load->model('Register21', 'register');
  }

  public function index()
  {
    $data['title'] = 'Register';
    $data['setting'] = $this->db->get_where('kop_surat', ['id' => 1])->row_array();
    $this->form_validation->set_rules($this->_rolesRegister());
    $setatu = $this->db->get_where('kop_surat', ['id' => 1])->row_array();
    if ($this->form_validation->run() == false) {
      $this->load->view('themplate/Register/header', $data);
      $this->load->view('Register/Registration', $data);
      $this->load->view('themplate/Register/footer', $data);
    } else {
      $data = [
        'nama' => htmlspecialchars($this->input->post('nama', true)),
        'nisn' => htmlspecialchars($this->input->post('nisn', true)),
        'email' => htmlspecialchars($this->input->post('email', true)),
        'nik' => htmlspecialchars($this->input->post('nik', true)),
        'isAktif' => htmlspecialchars(1, true),
        'roles_user' => htmlspecialchars(4, true),
        'tglDaftar' => date('y-m-d'),
        'pin' => password_hash(($this->input->post('password1', true)), PASSWORD_DEFAULT),
        'statusDaftar' => 1
      ];

      if ($this->register->regiterAkun($data) > 0) {
        $data = [
          'pin' => $this->input->post('email', true),
          'roles_user' => htmlspecialchars(4, true)
        ];

        $this->session->set_userdata($data);
        $this->session->set_flashdata('flash', 'success');
        $this->session->set_flashdata('message', '
        <div class="alert alert-success" role="alert">
          <p>Akun pdbd berhasil dibuat !!! silahkan lengkapi tahap demi tahap formulir di halaman ini, sampai anda memilik bukti registrasi ppdb ' . date('Y') . ' yang sah</p>
          <p class="text-warning">Halaman ini di buat untuk para pendaftar agar bisa memantau status pendaftarannya masing-masing, gunakan nisn dan pin yang telah terdaftar di awal untuk mengakses halaman ini.</p>
        </div>');
        redirect('Akun');
      } else {
        $this->session->set_flashdata('message', '
        <div class="alert alert-dager" role="alert">
          Registrasi akun Gagal,
        </div>');
        redirect('Register/Error');
      }
    }
  }

  public function Success()
  {
    $data['title'] = 'Success|Page';
    $data['setting'] = $this->db->get_where('kop_surat', ['id' => 1])->row_array();
    $this->load->view('themplate/Register/header', $data);
    $this->load->view('Register/success', $data);
    $this->load->view('themplate/Register/footer', $data);
  }

  public function Error()
  {
    $data['title'] = 'Error|Page';
    $data['setting'] = $this->db->get_where('kop_surat', ['id' => 1])->row_array();
    $this->load->view('themplate/Register/header', $data);
    $this->load->view('Register/error', $data);
    $this->load->view('themplate/Register/footer', $data);
  }

  // ambil data koreg

  private function _koreg()
  {
    return $this->register->koreg();
  }
  private function _noUrut()
  {
    return $this->register->urut();
  }
  
  // cek data nisn saat user pembuatan akun
  public function CekNisn(){
    if(isset($_POST['nisn'])){
       echo $this->register->cekNisnBiforeReg($_POST['nisn']);
    }
  }

   public function CekEmail(){
    if(isset($_POST['nisn'])){
       echo $this->register->cekEmailBiforeReg($_POST['nisn']);
    }
  }

  public function cekNIK(){
     if(isset($_POST['nik'])){
       echo $this->register->cekNikBiforeReg($_POST['nik']);
    }
  }


  // block private function

  private function _rolesRegister()
  {
    $dataRules = array(
      array(
        'field' => 'email',
        'label' => 'Email',
        'rules' => 'required|trim|valid_email|is_unique[register.email]',
        'errors' => array(
          'required'     => 'Email Harus Di isi',
          'valid_email'  => 'Email yg anda masukan tidak benar',
          'is_unique'    => ' %s sudah terdaftar.'
        )

      ), array(
        'field' => 'nama',
        'label' => 'Nama',
        'rules' => 'required|trim|max_length[100]',
        'errors' => array(
          'required' => 'nama Harus Di isi',
          'max_length' => 'Maxsimal 100 Karakter'
        )

      ), array(
        'field' => 'nisn',
        'label' => 'NISN',
        'rules' => 'required|trim|max_length[10]|is_unique[register.nisn]|min_length[10]',
        'errors' => array(
          'required' => 'NISN Harus Di isi',
          'max_length' => 'Maxsimal 10 Angka',
          'min_length' => 'Harus 10 Angka',
          'is_unique'    => ' %s sudah terdaftar.'
        )

      ),
      array(
        'field' => 'nik',
        'label' => 'NIK',
        'rules' => 'required|trim|max_length[16]|min_length[16]|is_unique[register.nik]',
        'errors' => array(
          'required' => 'NISN Harus Di isi',
          'max_length' => 'Harus 16 Angka',
          'min_length' => 'Harus 16 Angka',
          'is_unique'    => ' %s sudah terdaftar.'
        )

      ),
      array(
        'field' => 'password1',
        'label' => 'Password',
        'rules' => 'required|min_length[3]',
        'errors' => array(
          'required' => 'Password/Pin tidak boleh kosong',
          'min_length' => 'Password Minimal 3 Karakter'


        )
      ),
      array(
        'field' => 'password2',
        'label' => 'Password',
        'rules' => 'required|min_length[3]|matches[password1]',
        'errors' => array(
          'required' => 'Password/Pin tidak boleh kosong',
          'min_length' => 'Password/Pin Minimal 3 Karakter',
          'matches' => 'Password/Pin tidak sama'


        )
      )

    );
    return $dataRules;
  }
}
