<div class="container custum-section-head">
    <div class="row">
        <div class="col-12 col-lg-2 d-lg-flex justify-conten-center">
            <div class="logo-sekolah">
                <img src="<?= base_url('assets/img/logo/') . $setting['logo'] ?>" alt="<?= $setting['logo'] ?>" class="img-fluid">
            </div>
        </div>
        <div class="col-12 col-lg-6">
            <div class="text-section-head">
                <h2 data-aos="fade-in-out">Selamat Datang</h2>
                <h3 data-aos="fade-in">Di PPDB <?= $setting['nama_sekolah'] ?></h3>
                <p>Website ini digunakan untuk Penerimaan Peserta Didik Baru <?= $setting['nama_sekolah'] ?> tahun <?= date('Y') ?>, silahkan ikuti langkah demi langkah aturan/tatacara pendaftarannya</p>
                <p class="text-danger font-weight-bold font-italic">Agar sistem bisa berjalan dengan maksimal gunakan browser Google Chrome / Mozilla Firefox versi terbaru</p>
                <a href="<?= base_url('Register') ?>" class="tombol-daftar-sekarang">Daftar Sekarang</a>
                <a href="<?= base_url('Authentication') ?>" class="tombol-masuk-sekarang">Cek Status Pendaftaran</a>
            </div>
        </div>
    </div>
</div>

<!-- status card -->
<?php if ($setting['statistik_depan'] == 1) : ?>
    <section class="container status-card-container mt-5">
        <div class="row">
            <div class="col">
                <h2>Status Pendaftaran</h2>
            </div>
        </div>
        <div class="row m-auto">
            <?php foreach ($statistik as $ppdb) : ?>
                <div class="col-md-4 col-xs-12 col-lg-4 col-xl-4">
                    <div class="status-card d-flex flex-column justify-content-between">
                        <div class="status-card-title">
                            <h4><?= $ppdb['nama_jalur']; ?> <i class="fa-solid fa-map-location"></i></h4>
                        </div>
                        <div class="status-card-body d-flex flex-rows  justify-content-between">
                            <div class="status-card-statistik">
                                <h4>Quota</h4>
                                <h6><?= $ppdb['quota']; ?> <i class="fa-solid fa-user"></i></h6>
                            </div>
                            <div class="status-card-statistik">
                                <h4>Pendaftar</h4>
                                <h6><?= $ppdb['pendaftar']; ?> <i class="fa-solid fa-user"></i></h6>
                            </div>
                            <div class="status-card-statistik">
                                <h4>Terverivikasi</h4>
                                <h6><?= $ppdb['terverifikasi']; ?> <i class="fa-solid fa-user"></i></h6>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
<?php endif; ?>

<!-- section main -->
<section class="main-section mt-5" id="caraDaftar">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-4">
                <h2 class="title-section">Informasi</h2>
            </div>
        </div>
        <div class="row">
            <?php $delai = 90;
            $duration = 1000;
            foreach ($informasi as $info) :
            ?>

                <div class="col-12 col-md-4 col-xs-12 col-sm-12 col-xl-4 col lg-4">
                    <a href="<?= base_url('Home/View/') . $info['id']; ?>">
                        <div class="informasi-admin" data-aos="fade-right" data-aos-delay="<?= $delai + 10 ?>" data-aos-duration="<?= $duration - 20 ?>">
                            <h1 class="title-informasi"><?= $info['title']; ?>
                            </h1>
                            <div class="d-flex flex-row create-informasi justify-content-between">
                                <h4 class="date-informasi"><?php echo (date('d-m-Y H:i:s', $info['date_created'])); ?></h4>
                                <h6 class="author-informasi">
                                    Oleh: <?= $info['by_created']; ?>
                                </h6>
                            </div>
                            <div class="body-informasi">
                                <p class="mb-1"><?php substr($info['deskripsi'], 0, 100); ?></p>
                            </div>
                        </div>
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>