<!-- Begin Page Content -->
<div class="container-fluid">
  <?php if (validation_errors()) : ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <strong>Warning!! Data gagal disimpan</strong> <?= validation_errors() ?>
      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
  <?php endif ?>
  <!-- Page Heading -->
  <h1 class="h3 mb-4 text-gray-800"><?= $title ?></h1>
  <?= $this->session->flashdata('message') ?>
  <div class="row">
    <div class="col">
      <form action="<?= base_url('ppdb/informasi') ?>" method="POST" id="formUser">
        <input type="hidden" name="idInformasi" id="idInformasi">
        <div class="modal-body">
          <div class="form-group">
            <input type="text" class="form-control" value="<?= set_value('titleInformasi') ?>" id="titleInformasi" name="titleInformasi" placeholder="Title / Judul Informasi">
          </div>
          <div class="form-group">
            <textarea type="text" class="form-control deskripsi" id="deskripsi" name="deskripsi" placeholder="deskrisi Baru" value=""> <?= set_value('deskripsi') ?></textarea>
          </div>
          <button type="submit" class="btn btn-primary" id="buttonEditSimpanInformasi">Simpan Informasi</button>
        </div>
      </form>
    </div>
  </div>
  <div class="row">
    <div class="col-lg">
      <table class="table table-hover table-responsive-sm">
        <thead>
          <tr>
            <th scope="col">#</th>
            <th scope="col">Title</th>
            <th scope="col">Tanggal Publish</th>
            <th scope="col">Oleh</th>
            <th scope="col">action</th>
          </tr>
        </thead>
        <tbody>
          <?php $no = 1;
          foreach ($informasi as $info) : ?>
            <tr>
              <th scope="row"><?= $no++ ?></th>
              <td><?= $info['title']; ?></td>
              <td><?= date('d F Y', $info['date_created']); ?></td>
              <td><?= $info['by_created']; ?></td>
              <td>
                <a href="#" class="badge badge-success tombolEditInformasi" data-id="<?= $info['id'] ?>"><i class="fas fa-edit"></i> Edit </a>
                <a href="<?= base_url('ppdb/hapusInformasi/') . $info['id'] ?>" onclick="return confirm('Yakin Akan dihapus');" class="badge badge-danger"><i class="fas fa-trash"></i> hapus </a>
              </td>
            </tr>
          <?php endforeach ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<!-- /.container-fluid -->
</div>
<!-- End of Main Content -->
<!-- Modal -->
<script src="<?= base_url('assets/') ?>ckeditor/ckeditor.js"></script>
<script>
  CKEDITOR.replace('deskripsi');
</script>
    